#ifndef _ENTRY_CPP
#define _ENTRY_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <WinSock.H>
#include <Windows.H>
#include <WindowsX.H>
#include <ShlOBJ.H>
#include <CommCtrl.H>
#include <StdIO.H>
#include <IO.H>
#include <IPHlpAPI.h>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "CCmdLine.H"

#include "NSWFL.H"
#include "Debug.H"
#include "Entry.H"
#include "Init.H"
#include "Routines.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HINSTANCE ghAppInstance = NULL;

char gsAppCopyRight[64];
char gsFileVersion[32];
char gsTitleCaption[64];
char gsRegistryKey[255];

CMemoryPool gMem; //The global memory object.

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AppEntry(HINSTANCE hInstance, CCmdLine *lpCmdLine)
{
	HANDLE hMutex = NULL;

	if( (hMutex = OpenMutex(SYNCHRONIZE, FALSE, gsTitleCaption)) )
	{
		MessageBox(NULL, "Only one instance can run at a time!",
			gsTitleCaption, MB_ICONASTERISK | MB_SYSTEMMODAL);

		ReleaseMutex(hMutex);
		CloseHandle(hMutex);
		return 0;
	}
	else hMutex = CreateMutex(0, 0, gsTitleCaption);

	//--------------------------------------------------------------------------

    DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, MainDialog);

	//--------------------------------------------------------------------------

	ReleaseMutex(hMutex);
	CloseHandle(hMutex);

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
int main(int argc, char *argv[])
#else
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevious, LPSTR CmdLine, int CmdShow)
#endif
{
    #ifdef _DEBUG
	ghAppInstance = GetModuleHandle(NULL);
    #else
	ghAppInstance = hInstance;
    #endif

    int iResult = 0;

	if(!InitializeApp())
    {
        return 1;
    }

    CCmdLine MyCmdLine;

	if(MyCmdLine.Alloc())
	{
		iResult = AppEntry(ghAppInstance, &MyCmdLine);

		MyCmdLine.Free();
	}

    if(!UninitializeApp())
    {
        return 1;
    }

	return iResult;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

